
#ifndef SoftwareSerial_h
#define SoftwareSerial_h

#include <inttypes.h>
#include <stddef.h>

//
// Types
//
typedef uint8_t boolean;
typedef uint8_t byte;

//
// Definitions
//
#define _SS_MAX_RX_BUFF 64 // RX buffer size, must be (1<<n)
#define _SS_RX_BUFF_MASK (_SS_MAX_RX_BUFF-1)
#define _SS_MAX_TX_BUFF 64 // TX buffer size, must be (1<<n)
#define _SS_TX_BUFF_MASK (_SS_MAX_TX_BUFF-1)

#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)
#endif

//
// public methods
//
void softSerialInit( volatile uint8_t *ddr,
                     volatile uint8_t *port,
                     volatile uint8_t *pin,
                     uint8_t rx,
                     uint8_t tx );
void softSerialBegin(long speed);
void softSerialEnd();
bool softSerialOverflow();
int16_t softSerialPeek();
void softSerialWrite(uint8_t byte);
int16_t softSerialRead();
uint8_t softSerialAvailable();
void softSerialFlush();
uint8_t softSerialReadBytes(uint8_t *buf, uint8_t buf_len);
        
#endif