#ifndef LED_H
#define LED_H

#include <stdint.h>
#include <stdbool.h>

// min_id (8-bit)
// 0x00-0x0f 	ID LED lamp 1 - 16 -> function + value
// 0x10-0x1F	Response ID LED lamp 1 - 16
// 0x3E         all LED -> function + value (no response)
// 0X3F         -
//
// Payload /Response
// Byte 1	Function
//  0x00	LED Off
//	0x01	LED Off (stored delay) 	
//	0x02	LED On
//	0x03	LED On (stored value/delay) 
//	0x04	Set stored value/delay
//	0x05	Get stored value/delay
//	0x..    
// Byte 2	Value	1..255 	LED brightness
// Byte 3	Delay	0..255 	LED ramp up/down delay

// Payload Response Error
// Byte 1	0xFF  
// Byte 2	Error code	
//           0x00   Payload size wrong (byte 3 = wrong size value))
//           0x01   Unknown Function
// Byte 3	0x??

#define FADING_TIME         25          // fading step time: 1 = 2.048ms
#define LED_PAYLOAD_SIZE    3           // number of data bytes
#define LED_GLOBAL          0x3E        // all LEDs
#define LED_RESPONSE_BIT    0x10    

// LED ERROR CODES
#define LED_ERROR               0xFF
#define LED_ERROR_PAYLOAD_SIZE  0x00
#define LED_UNKNOWN_FUNC        0x01

// LED Function
#define LED_OFF             0x00        
#define LED_OFF_STORED      0x01
#define LED_ON              0x02 
#define LED_ON_STORED       0x03 
#define LED_SET_STORED      0x04 
#define LED_GET_STORED      0x05
#define LED_STATUS          0x06
#define LED_STATUS          0x06
#define LED_STAT_ONOFF      0x07

// EEPROM data
#define EE_INIT             0x00
#define EE_SELF_ID          0x01
#define EE_VALUE            0x02
#define EE_DELAY            0x03

void led_function(uint8_t *function, uint8_t *value, uint8_t *delay);
uint8_t get_self_id(void); 
void init_led(void);
void flash_led(uint8_t id);
void stat_led_on(void);
void stat_led_off(void);

#endif //LED_H