import os.path
from optparse import OptionParser

parser = OptionParser()
parser.add_option("-i", "--input", dest="selectedFile",
                  help="OTA input FILE to read", metavar="FILE")
parser.add_option("-o", "--output", dest="imageFile",
                  help="write image to FILE", metavar="FILE")

# NGIS/OTA?Image IDs and offsets
NGIS_ID = 0
NGIS_ID_VALUE = 'NGIS'
NGIS_OTA_START = 16
OTA_ID = 0
OTA_ID_VALUE = 0xBEEF11E
OTA_FILE_VERSION = 14
OTA_HEADER_LENGTH = 6
OTA_STRING = 20
OTA_LENGTH = 2
IMAGE_ID = 6
IMAGE_ID_VALUE = 0x50E301028C000000
NODE_ADDR_0 = 14
NODE_DATA_0 = 22
NODE_DATA_LENGTH_0 = 128
NODE_BLOCKS = 150
NODE_ADDR = 4
NODE_DATA_LENGTH = 2
NODE_DATA = 8
DATA_ID = 0
DATA_ID_BLOCK = 0xFD03
DATA_ID_END = 0xFC04

(options, args) = parser.parse_args()
selectedFile = options.selectedFile
imageFile = options.imageFile

if not(os.path.isfile(selectedFile)):
	print("No input file found")
	exit()
print("OTA Input File: \t" + selectedFile)
print("Image Output File: \t" + imageFile)

# open the files
myFile = open(selectedFile, "rb")
myImage = open(imageFile, "wb")

# read NGIS ID in input file
myFile.seek(NGIS_ID,0)
string = myFile.read(4).decode('ascii')
if string != NGIS_ID_VALUE:
	print("NGIS identifier missing! \t", string)
	exit()

# read offset to OTA image
myFile.seek(NGIS_OTA_START,0)
ota_start = int.from_bytes(myFile.read(4), byteorder='little')
# print("NGIS OTA start: \t", hex(ota_start))

# read OTA ID
myFile.seek(ota_start+OTA_ID,0)
ota_id = int.from_bytes(myFile.read(4), byteorder='little')
if ota_id != OTA_ID_VALUE:
	print("OTA identifier missing! \t", hex(ota_id))
	exit()

# read file version
myFile.seek(ota_start+OTA_FILE_VERSION,0)
data = int.from_bytes(myFile.read(4), byteorder='little')
print("OTA file version: \t", str((data & 0xF0000000)>>28) + "." + \
	str((data & 0x0F000000) >> 24) + "." + \
	str((data & 0x00F00000) >> 20) + str((data & 0x000F0000) >> 16) + str((data & 0x0000F000) >> 12) + "." + \
	str((data & 0x00000F00) >> 8) + str((data & 0x000000F0) >> 4) +str((data & 0x0000000F)) \
	)

# read length of OTA header
myFile.seek(ota_start+OTA_HEADER_LENGTH,0)
ota_header_length = int.from_bytes(myFile.read(2), byteorder='little')
#print("OTA file length: \t", hex(ota_header_length))

# read OTA header string
myFile.seek(ota_start+OTA_STRING,0)
string = myFile.read(32).decode('ascii')
string = string.rstrip("\0")
print("OTA header string: \t", string)

# read length of OTA image
#myFile.seek(ota_start+ota_header_length+OTA_LENGTH,0)
#ota_length = int.from_bytes(myFile.read(4), byteorder='little')
#print("OTA file length: \t", hex(ota_length))

# read IMAGE ID
myFile.seek(ota_start+ota_header_length+IMAGE_ID,0)
image_id = int.from_bytes(myFile.read(8), byteorder='little')
if image_id != IMAGE_ID_VALUE:
	print("IMAGE identifier missing! \t", hex(image_id))
	exit()

# read node address 0
myFile.seek(ota_start+ota_header_length+NODE_ADDR_0,0)
addr = int.from_bytes(myFile.read(4), byteorder='big')

# read first 128 byte data
myFile.seek(ota_start+ota_header_length+NODE_DATA_0,0)
data = myFile.read(NODE_DATA_LENGTH_0)
print(" NODE addr: %s / length: %s \t" % (hex(addr), hex(NODE_DATA_LENGTH_0)))

# write first 128 bytes to target file
# start vom 0 (not 0x4000)
myImage.seek(addr-0x4000,0)
myImage.write(data)

block_start = ota_start+ota_header_length+NODE_BLOCKS
myFile.seek(block_start + DATA_ID, 0)
data_id = int.from_bytes(myFile.read(2), byteorder='big')
image_size = NODE_DATA_LENGTH_0

# loop until last block is reached...
while data_id == DATA_ID_BLOCK:
	myFile.seek(block_start+DATA_ID,0)
	data_id = int.from_bytes(myFile.read(2), byteorder='big')
	myFile.seek(block_start+NODE_ADDR,0)
	addr = int.from_bytes(myFile.read(4), byteorder='big')
	myFile.seek(block_start+NODE_DATA_LENGTH,0)
	length = int.from_bytes(myFile.read(2), byteorder='big')
	myFile.seek(block_start+NODE_DATA,0)
	data = myFile.read(length-4)
	if data_id == DATA_ID_BLOCK:
		print(" NODE addr: %s / length: %s \t" % (hex(addr), hex(length-4)))
		myImage.seek(addr - 0x4000, 0)
		myImage.write(data)
		block_start += (length + 4)
		image_size += (length - 4)
		continue
	if data_id == DATA_ID_END:
		print("Image bytes written: \t", hex(image_size))
		continue
	print("Unknown data id found!", hex(data_id))

# close the files
myFile.close()
myImage.close()
