
// SI4684 COMMAND CODE
#define SI46XX_RD_REPLY         			0x00
#define SI46XX_POWER_UP         			0x01
#define SI46XX_HOST_LOAD        			0x04
#define SI46XX_FLASH_LOAD       			0x05
#define SI46XX_LOAD_INIT       	 			0x06
#define SI46XX_BOOT             			0x07
#define SI46XX_GET_PART_INFO        		0x08
#define SI46XX_GET_SYS_STATE        		0x09
#define SI46XX_GET_POWER_UP_ARGS    		0x0A

#define SI46XX_READ_OFFSET					0x10
#define SI46XX_GET_FUNC_INFO        		0x12
#define SI46XX_SET_PROPERTY         		0x13
#define SI46XX_GET_PROPERTY         		0x14
#define SI46XX_WRITE_STORAGE				0x15
#define SI46XX_READ_STORAGE					0x16

#define SI46XX_FM_TUNE_FREQ         		0x30
#define SI46XX_FM_SEEK_START        		0x31
#define SI46XX_FM_RSQ_STATUS        		0x32
#define SI46XX_FM_ACF_STATUS        		0x33
#define SI46XX_FM_RDS_STATUS        		0x34
#define SI46XX_FM_RDS_BLOCKCOUNT    		0x35

#define SI46XX_GET_DIGITAL_SERVICE_LIST 	0x80
#define SI46XX_START_DIGITAL_SERVICE    	0x81
#define SI46XX_STOP_DIGITAL_SERVICE			0x82
#define SI46XX_GET_DIGITAL_SERVICE_DATA     0x84

#define SI46XX_HD_DIGRAD_STATUS				0x92
#define SI46XX_HD_GET_EVENT_STATUS			0x93
#define SI46XX_HD_GET_STATION_INFO			0x94
#define SI46XX_HD_GET_PSD_DECODE			0x95
#define SI46XX_HD_GET_ALERT_MSG				0x96
#define SI46XX_HD_PLAY_ALERT_TONE			0x97
#define SI46XX_HD_TEST_GET_BER_INFO			0x98
#define SI46XX_HD_SET_ENABLED_PORTS			0x99
#define SI46XX_HD_GET_ENABLED_PORTS			0x9A
#define SI46XX_HD_ACF_STATUS				0x9C

#define SI46XX_DAB_TUNE_FREQ 				0xB0
#define SI46XX_DAB_DIGRAD_STATUS 			0xB2
#define SI46XX_DAB_GET_EVENT_STATUS			0xB3
#define SI46XX_DAB_GET_ENSEMBLE_INFO 		0xB4
#define SI46XX_DAB_GET_ANNOUNCEMENT_SUPPORT_INFO	0xB5
#define SI46XX_DAB_GET_ANNOUNCEMENT_INFO	0xB6
#define SI46XX_DAB_GET_SERVICE_LINKING_INFO	0xB7
#define SI46XX_DAB_SET_FREQ_LIST      		0xB8
#define SI46XX_DAB_GET_FREQ_LIST      		0xB9
#define SI46XX_DAB_GET_COMPONENT_INFO		0xBB
#define SI46XX_GET_TIME						0xBC
#define SI46XX_DAB_GET_AUDIO_INFO 			0xBD
#define SI46XX_DAB_GET_SUBCHAN_INFO       	0xBE
#define SI46XX_DAB_GET_FREQ_INFO			0xBF

#define SI46XX_DAB_GET_SERVICE 				0xC0
#define SI46XX_DAB_GET_OE_SERVICES_INFO		0xC1
#define SI46XX_DAB_ACF_STATUS				0xC2

#define SI46XX_TEST_GET_RSSI				0xE5
#define SI46XX_DAB_TEST_GET_BER_INFO		0xE8

// DAB FREQUENCIES in KHz
const PROGMEM uint32_t dab_freq[] = 
  {174928, 176640, 178352, 180064, 181936, 183648, 185360, 187072, 
   188928, 190640, 192352, 194064, 195936, 197648, 199360, 201072,
   202928, 204640, 206352, 208064, 209936, 211648, 213360, 215072, 
   216928, 218640, 220352, 222064, 223936, 225648, 227360, 229072,
   230784, 232496, 234208, 235776, 237488, 239200
    };

// NUMBER OF DAB FREQUENCIES
#define DAB_FREQS (sizeof(dab_freq) / sizeof(dab_freq[0]))

// SPI BUFFER 
#define SPI_BUFF_SIZE 512
unsigned char spi_buf[SPI_BUFF_SIZE];	// SPI buffer 

uint8_t   	chip_rev;		// si468x chip revision
uint8_t   	rom_id;			// si468x rom id
uint16_t  	part_no;		// si468x part number
uint8_t   	ver_major;		// firmware version major
uint8_t   	ver_minor;		// firmware version minor
uint8_t   	ver_build;		// firmware version build
uint16_t	freq;			// FM frequency / 10
uint32_t	dabfreq;		// DAB frequency
int8_t		rssi;			// RSSI [dBuV]
int8_t		snr;			// SNR [dB]
bool		valid;			// DAB valid ensemble
uint8_t		cmd_error = 0;	// si468x command error
uint16_t	fm_pi;			// FM program ID
uint8_t		fm_pty;			// FM program type 
uint16_t  	blockA;			// block A data from RDS FIFO		
uint16_t  	blockB;			// block B data from RDS FIFO
uint16_t  	blockC;			// block C data from RDS FIFO
uint16_t  	blockD;			// block D data from RDS FIFO
uint16_t	blk_exp;		// RDS blocks expected
uint16_t 	blk_rec;		// RDS blocks received
uint16_t 	audio_bit_rate;	// audio bit rate of the current audio service (kbps)
uint16_t 	audio_sample_rate;	// Sample rate of the current audio service (Hz)
uint8_t		audio_mode;		// audio_mode 0: dual,1: mono,2: stereo,3: joint stereo
bool		dabplus;		// DAB+
uint8_t 	service_mode;	// Indicates the service mode of the sub-channel e.g. 4: DAB+,5: DAB
